viewer.mode=OVERLAY

function setup()
    print("reorder tabs to see different versions")
    --  3, 9, 27, 81
    ss=3     
    assert(OrbitViewer, "Please include Cameras as a dependency")
    scene1 = craft.scene() 
    v=scene1.camera:add(OrbitViewer,vec3(51,50.5,50), 7, 0, 1000)
    
    scene1.voxels.blocks:addAssetPack("Blocks")
    tab = scene1.voxels.blocks:new("Table")
    tab.setTexture(ALL, "Blocks:Table")
    
    scene1.voxels:fill("Table")    
    scene1.voxels.visibleRadius=200
    scene1.voxels:resize(vec3(60,1,60))          
    scene1.voxels.coordinates = vec3(50,50,50) 
    entity = scene1:entity()
    volume = entity:add(craft.volume, 200, 200, 200)
    
    cube(0,0,0,ss)
    parameter.action("nxt", function()
        ss = ss * 3
        if ss > 81 then
            cube(0,0,0, nil, true)
            ss = 3 
        end
        cube(0,0,0,ss)
    end)
end

function update(dt)
    scene1:update(dt)
end

function draw()
    update(DeltaTime)
    scene1:draw()  
end

function cube(x,y,z, size, clear)
    if clear then
        scene1.voxels:fill( 'name', 'empty')
        scene1.voxels:box(0, 0, 0, 200, 200, 200)
        return
    end
    local s=size/3
    for x1=-s,s,s do
        for y1=-s,s,s do
            for z1=-s,s,s do
                if (y1~=0 or z1~=0) and (x1~=0 or z1~=0) and (x1~=0 or y1~=0) then
                    if size ~= 3 then
                        cube(x1+x,y1+y,z1+z, s)
                    else
                        scene1.voxels:fill("Table")
                        scene1.voxels:block((x1+x+50),(y1+y+50),(z1+z+50))
                    end                                   
                end
            end            
        end
    end
    v.zoom = size * 1.75
end   